#version 110

uniform float radius;

void main() {
	float distance = sqrt(gl_TexCoord[0].x * gl_TexCoord[0].x + gl_TexCoord[0].y * gl_TexCoord[0].y);
	distance = floor(distance * 50.0) / 50.0;
	float outerCircle = (1.0 - step(radius, distance)) * step(radius - 0.04, distance);
	float innerCircle = (1.0 - step(radius * 0.7, distance)) * step(radius * 0.7 - 0.04, distance);
	float angle = atan(gl_TexCoord[0].y, gl_TexCoord[0].x);
	float arc = step(1.7825957145940461, angle) * (1.0 - step(3.141592653589793, angle));
	float alpha = max(outerCircle, innerCircle * arc);
	
	gl_FragColor = vec4(1.0, 1.0, 1.0, alpha);
}
